{{-- resources/views/peninjauan/partials/edit-tab-pendaftaran.blade.php --}}

<!-- Pendaftaran Tab -->
<div class="tab-pane fade" id="pendaftaran" role="tabpanel">
    <div class="card">
        <div class="card-header">

            Penelitian Penguasaan Tanah
        </div>
        <div class="card-body">
            <!-- BA Penelitian Section -->
            <h5 class="section-title">BA Penelitian Penguasaan Tanah</h5>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nomor_ba_penelitian">Nomor BA Penelitian Penguasaan Tanah</label>
                        <input type="text" class="form-control" id="nomor_ba_penelitian" name="nomor_ba_penelitian"
                               value="{{ old('nomor_ba_penelitian', $peninjauan->nomor_ba_penelitian) }}"
                               placeholder="Nomor BA Penelitian">
                        @error('nomor_ba_penelitian')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="bulan_tahun_penelitian">Pada Bulan dan Tahun</label>
                        <input type="month" class="form-control" id="bulan_tahun_penelitian" name="bulan_tahun_penelitian"
                               value="{{ old('bulan_tahun_penelitian', $peninjauan->bulan_tahun_penelitian) }}">
                        @error('bulan_tahun_penelitian')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Data Penguasaan Section -->
            <h5 class="section-title">Data Penguasaan</h5>

          

            <div class="row mb-3">
                 <div class="col-6">
                    <div class="form-group">
                        <label for="penguasaan_tanah_detail">Penguasaan Tanah</label>
                        <input type="text" class="form-control" id="penguasaan_tanah_detail" name="penguasaan_tanah_detail"
                               value="{{ old('penguasaan_tanah_detail', $peninjauan->penguasaan_tanah_detail) }}"
                               placeholder="Detail penguasaan tanah">
                        @error('penguasaan_tanah_detail')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="riwayat_perolehan">Riwayat Perolehan Tanah</label>
                        <select class="form-control" id="riwayat_perolehan" name="riwayat_perolehan">
                            <option value="">-- Pilih --</option>
                            <option value="jual beli" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'jual beli' ? 'selected' : '' }}>Jual Beli</option>
                            <option value="pelepasan penguasaan" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'pelepasan penguasaan' ? 'selected' : '' }}>Pelepasan Penguasaan</option>
                            <option value="hibah" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'hibah' ? 'selected' : '' }}>Hibah</option>
                            <option value="tukar menukar" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'tukar menukar' ? 'selected' : '' }}>Tukar Menukar</option>
                            <option value="surat keterangan waris" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'surat keterangan waris' ? 'selected' : '' }}>Surat Keterangan Waris</option>
                            <option value="akta pembagian hak bersama" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'akta pembagian hak bersama' ? 'selected' : '' }}>Akta Pembagian Hak Bersama</option>
                            <option value="lelang" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'lelang' ? 'selected' : '' }}>Lelang</option>
                            <option value="wasiat" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'wasiat' ? 'selected' : '' }}>Wasiat</option>
                            <option value="putusan pengadilan" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'putusan pengadilan' ? 'selected' : '' }}>Putusan Pengadilan</option>

                            <option value="lainnya" {{ old('riwayat_perolehan', $peninjauan->riwayat_perolehan) == 'lainnya' ? 'selected' : '' }}>Lainnya</option>


                        </select>
                        @error('riwayat_perolehan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Data Yuridis Section -->
            <h5 class="section-title">Data Yuridis</h5>

            {{-- <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="data_yuridis">Data Yuridis</label>
                        <textarea class="form-control" id="data_yuridis" name="data_yuridis" rows="3"
                                  placeholder="Masukkan data yuridis">{{ old('data_yuridis', $peninjauan->data_yuridis) }}</textarea>
                        @error('data_yuridis')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div> --}}

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="data_pendukung">Data Pendukung</label>
                        <textarea class="form-control" id="data_pendukung" name="data_pendukung" rows="3"
                                  placeholder="Masukkan data pendukung">{{ old('data_pendukung', $peninjauan->data_pendukung) }}</textarea>
                        @error('data_pendukung')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Photo Dokumentasi Section -->
            <h5 class="section-title">Photo Dokumentasi/Kwitansi Bukti Perolehan Tanah</h5>

            @if($peninjauan->photo_dokumentasi)
            <div class="row mb-3">
                <div class="col-12">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> File dokumentasi sudah ada. Upload file baru untuk mengganti.
                    </div>
                </div>
            </div>
            @endif

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="photo_dokumentasi">Upload Photo/Dokumen</label>
                        <input type="file" class="form-control-file" id="photo_dokumentasi" name="photo_dokumentasi[]"
                               multiple accept="image/*,application/pdf">
                        <small class="text-muted">Format: JPG, PNG, PDF. Maksimal 5MB per file. Bisa upload multiple files.</small>
                        @error('photo_dokumentasi')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                        @error('photo_dokumentasi.*')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- IMB dan SPPT Section -->
            <h5 class="section-title">IMB dan SPPT PBB</h5>

            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="imb_tanggal">IMB Tanggal</label>
                        <input type="date" class="form-control" id="imb_tanggal" name="imb_tanggal"
                               value="{{ old('imb_tanggal', $peninjauan->imb_tanggal) }}">
                        @error('imb_tanggal')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="no_imb">No IMB</label>
                        <input type="text" class="form-control" id="no_imb" name="no_imb"
                               value="{{ old('no_imb', $peninjauan->no_imb) }}"
                               placeholder="Nomor IMB">
                        @error('no_imb')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="sppt_pbb_tahun">SPPT PBB Tahun</label>
                        <input type="number" class="form-control" id="sppt_pbb_tahun" name="sppt_pbb_tahun"
                               value="{{ old('sppt_pbb_tahun', $peninjauan->sppt_pbb_tahun) }}"
                               placeholder="Tahun" min="1900" max="{{ date('Y') }}">
                        @error('sppt_pbb_tahun')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        <!-- Form Actions -->
        <div class="card-footer d-flex justify-content-between">
            {{-- <button type="button" class="btn btn-secondary" onclick="previousTab()">
                ← Sebelumnya
            </button>
            <div>
                <button type="button" class="btn btn-secondary mr-2" onclick="saveDraft()">
                    💾 Simpan Draft
                </button>
                <button type="button" class="btn btn-primary" onclick="nextTab()">
                    Selanjutnya →
                </button>
            </div> --}}
        </div>
    </div>
</div>
